unit IWDBStdCtrls32;
{PUBDIST}

interface

uses
  {$IFDEF VSNET}
  System.ComponentModel, System.ComponentModel.Design, System.Drawing,
  System.Drawing.Design, System.Data, IWConnectorsCache,
  IWNetClasses, IWNetComponent, AdoNetDb, 
  {$ENDIF}
  {$IFDEF Linux}QControls,
  {$ELSE}
    {$IFNDEF VSNET}
    Controls,
    {$ENDIF}
  {$ENDIF}
  Classes, DB,
  IWControl32, IWCompCheckbox32, IWCompEdit32, IWCompLabel32, IWCompListbox32, IWCompMemo32,
  IWCompText32, IWHTMLTag, IWRenderContext, IWBaseInterfaces;

type
  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWDBCheckBox32.bmp}
  TIWDBCheckBox32 = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWDBCheckBox32), 'TIWDBCheckBox32.bmp'),
    TIWToolPalette('Intraweb 3.2 DB Controls')]
  {$ENDIF}
  TIWDBCheckBox32 = class(TIWCustomCheckBox32, IIWInputControl)
  protected
    FAutoEditable: Boolean;
    FDataField: string;
    FDataSource: TDataSource;
    FValueChecked: string;
    FValueUnchecked: string;
    //
    {$IFDEF VSNET}
    procedure Notification(AComponent: TPlatformComponent; AOperation: TOperation); override;
    {$ELSE}
    procedure Notification(AComponent: TComponent; AOperation: TOperation); override;
    {$ENDIF}
    procedure SetDataField(const AValue: string);
    procedure SetValue(const AValue: string); override;
    procedure InitControl; override;
    {$IFDEF VSNET}
    procedure SetDataset(const Dataset: System.Data.DataTable);
    function GetDataset: System.Data.DataTable;
    function ShouldSerializeDataset: Boolean;
    {$ENDIF}
  public
    function RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag; override;
    destructor Destroy; override;
  published
    property AutoEditable: Boolean read FAutoEditable write FAutoEditable;
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property DataField: string read FDataField write SetDataField;
    {$IFDEF VSNET}
    property Dataset: System.Data.DataTable read GetDataset write SetDataset;
    {$ELSE}
    property DataSource: TDataSource read FDataSource write FDataSource;
    {$ENDIF}
    property ValueChecked: string read FValueChecked write FValueChecked;
    property ValueUnchecked: string read FValueUnchecked write FValueUnchecked;
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWDBComboBox32.bmp}
  TIWDBComboBox32 = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWDBComboBox32), 'TIWDBComboBox32.bmp'),
    TIWToolPalette('Intraweb 3.2 DB Controls')]
  {$ENDIF}
  TIWDBComboBox32 = class(TIWCustomCombobox32, IIWInputControl)
  protected
    FAutoEditable: Boolean;
    FDataField: string;
    FDataSource: TDataSource;
    //
    {$IFDEF VSNET}
    procedure Notification(AComponent: TPlatformComponent; AOperation: TOperation); override;
    {$ELSE}
    procedure Notification(AComponent: TComponent; AOperation: TOperation); override;
    {$ENDIF}
    procedure SetValue(const AValue: string); override;
    procedure InitControl; override;
    {$IFDEF VSNET}
    procedure SetDataset(const Dataset: System.Data.DataTable);
    function GetDataset: System.Data.DataTable;
    function ShouldSerializeDataset: Boolean;
    {$ENDIF}
  public
    destructor Destroy; override;
    function RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag; override;
  published
    property AutoEditable: Boolean read FAutoEditable write FAutoEditable;
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property DataField: string read FDataField write FDataField;
    {$IFDEF VSNET}
    property Dataset: System.Data.DataTable read GetDataset write SetDataset;
    {$ELSE}
    property DataSource: TDataSource read FDataSource write FDataSource;
    {$ENDIF}
    property ItemIndex;
    property Items;
    property Sorted;
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWDBEdit32.bmp}
  TIWDBEdit32 = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWDBEdit32), 'TIWDBEdit32.bmp'),
    TIWToolPalette('Intraweb 3.2 DB Controls')]
  {$ENDIF}
  TIWDBEdit32 = class(TIWCustomEdit32, IIWInputControl)
  protected
    FAutoEditable: Boolean;
    FDataField: string;
    FDataSource: TDataSource;
    //
    {$IFDEF VSNET}
    procedure Notification(AComponent: TPlatformComponent; AOperation: TOperation); override;
    {$ELSE}
    procedure Notification(AComponent: TComponent; AOperation: TOperation); override;
    {$ENDIF}
    procedure Paint; override;
    procedure SetValue(const AValue: string); override;
    procedure InitControl; override;
    {$IFDEF VSNET}
    procedure SetDataset(const Dataset: System.Data.DataTable);
    function GetDataset: System.Data.DataTable;
    function ShouldSerializeDataset: Boolean;
    {$ENDIF}
  public
    destructor Destroy; override;
    function RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag; override;
  published
    property AutoEditable: Boolean read FAutoEditable write FAutoEditable;
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property DataField: string read FDataField write FDataField;
    {$IFDEF VSNET}
    property Dataset: System.Data.DataTable read GetDataset write SetDataset;
    {$ELSE}
    property DataSource: TDataSource read FDataSource write FDataSource;
    {$ENDIF}
    property PasswordPrompt;
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWDBLabel32.bmp}
  TIWDBLabel32 = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWDBLabel32), 'TIWDBLabel32.bmp'),
    TIWToolPalette('Intraweb 3.2 DB Controls')]
  {$ENDIF}
  TIWDBLabel32 = class(TIWCustomLabel32)
  protected
    FDataField: string;
    FDataSource: TDataSource;
    //
    {$IFDEF VSNET}
    procedure Notification(AComponent: TPlatformComponent; AOperation: TOperation); override;
    {$ELSE}
    procedure Notification(AComponent: TComponent; AOperation: TOperation); override;
    {$ENDIF}
    procedure Paint; override;
    procedure InitControl; override;
    {$IFDEF VSNET}
    procedure SetDataset(const Dataset: System.Data.DataTable);
    function GetDataset: System.Data.DataTable;
    function ShouldSerializeDataset: Boolean;
    {$ENDIF}
  public
    destructor Destroy; override;
    function RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag; override;
  published
    property AutoSize;
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property DataField: string read FDataField write FDataField;
    {$IFDEF VSNET}
    property Dataset: System.Data.DataTable read GetDataset write SetDataset;
    {$ELSE}
    property DataSource: TDataSource read FDataSource write FDataSource;
    {$ENDIF}
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWDBListbox32.bmp}
  TIWDBListbox32 = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWDBListbox32), 'TIWDBListbox32.bmp'),
    TIWToolPalette('Intraweb 3.2 DB Controls')]
  {$ENDIF}
  TIWDBListbox32 = class(TIWCustomListbox32, IIWInputControl)
  protected
    FAutoEditable: Boolean;
    FDataField: string;
    FDataSource: TDataSource;
    //
    {$IFDEF VSNET}
    procedure Notification(AComponent: TPlatformComponent; AOperation: TOperation); override;
    {$ELSE}
    procedure Notification(AComponent: TComponent; AOperation: TOperation); override;
    {$ENDIF}
    procedure SetValue(const AValue: string); override;
    procedure InitControl; override;
    {$IFDEF VSNET}
    procedure SetDataset(const Dataset: System.Data.DataTable);
    function GetDataset: System.Data.DataTable;
    function ShouldSerializeDataset: Boolean;
    {$ENDIF}
  public
    destructor Destroy; override;
    function RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag; override;
  published
    property AutoEditable: Boolean read FAutoEditable write FAutoEditable;
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property DataField: string read FDataField write FDataField;
    {$IFDEF VSNET}
    property Dataset: System.Data.DataTable read GetDataset write SetDataset;
    {$ELSE}
    property DataSource: TDataSource read FDataSource write FDataSource;
    {$ENDIF}
    property Items;
    property ItemIndex;
    property Sorted;
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWDBLookupComboBox32.bmp}
  TIWDBLookupComboBox32 = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWDBLookupComboBox32), 'TIWDBLookupComboBox32.bmp'),
    TIWToolPalette('Intraweb 3.2 DB Controls')]
  {$ENDIF}
  TIWDBLookupComboBox32 = class(TIWCustomCombobox32, IIWInputControl)
  protected
    FAutoEditable: Boolean;
    FDataField: string;
    FDataSource: TDataSource;
    FKeyField: string;
    FKeyItems: TStrings;
    FListField: string;
    FListSource: TDataSource;
    //
    {$IFDEF VSNET}
    procedure Notification(AComponent: TPlatformComponent; AOperation: TOperation); override;
    {$ELSE}
    procedure Notification(AComponent: TComponent; AOperation: TOperation); override;
    {$ENDIF}
    procedure SetValue(const AValue: string); override;
    procedure InitControl; override;
    {$IFDEF VSNET}
    procedure SetDataset(const Dataset: System.Data.DataTable);
    function GetDataset: System.Data.DataTable;
    function ShouldSerializeDataset: Boolean;
    procedure SetListDataset(const Dataset: System.Data.DataTable);
    function GetListDataset: System.Data.DataTable;
    function ShouldSerializeListDataset: Boolean;
    {$ENDIF}
  public
    destructor Destroy; override;
    function RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag; override;
  published
    property AutoEditable: Boolean read FAutoEditable write FAutoEditable;
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property DataField: string read FDataField write FDataField;
    {$IFDEF VSNET}
    property Dataset: System.Data.DataTable read GetDataset write SetDataset;
    {$ELSE}
    property DataSource: TDataSource read FDataSource write FDataSource;
    {$ENDIF}
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property KeyField: string read FKeyField write FKeyField;
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property ListField: string read FListField write FListField;
    {$IFDEF VSNET}
    property ListDataset: System.Data.DataTable read GetListDataset write SetListDataset;
    {$ELSE}
    property ListSource: TDataSource read FListSource write FListSource;
    {$ENDIF}
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWDBLookupListBox32.bmp}
  TIWDBLookupListBox32 = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWDBLookupListBox32), 'TIWDBLookupListBox32.bmp'),
    TIWToolPalette('Intraweb 3.2 DB Controls')]
  {$ENDIF}
  TIWDBLookupListBox32 = class(TIWCustomListbox32, IIWInputControl)
  protected
    FAutoEditable: Boolean;
    FDataField: string;
    FDataSource: TDataSource;
    FKeyField: string;
    FKeyItems: TStrings;
    FListField: string;
    FListSource: TDataSource;
    //
    {$IFDEF VSNET}
    procedure Notification(AComponent: TPlatformComponent; AOperation: TOperation); override;
    {$ELSE}
    procedure Notification(AComponent: TComponent; AOperation: TOperation); override;
    {$ENDIF}
    procedure SetValue(const AValue: string); override;
    procedure InitControl; override;
    {$IFDEF VSNET}
    procedure SetDataset(const Dataset: System.Data.DataTable);
    function GetDataset: System.Data.DataTable;
    function ShouldSerializeDataset: Boolean;
    procedure SetListDataset(const Dataset: System.Data.DataTable);
    function GetListDataset: System.Data.DataTable;
    function ShouldSerializeListDataset: Boolean;
    {$ENDIF}
  public
    destructor Destroy; override;
    function RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag; override;
  published
    property AutoEditable: Boolean read FAutoEditable write FAutoEditable;
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property DataField: string read FDataField write FDataField;
    {$IFDEF VSNET}
    property Dataset: System.Data.DataTable read GetDataset write SetDataset;
    {$ELSE}
    property DataSource: TDataSource read FDataSource write FDataSource;
    {$ENDIF}
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property KeyField: string read FKeyField write FKeyField;
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property ListField: string read FListField write FListField;
    {$IFDEF VSNET}
    property ListDataset: System.Data.DataTable read GetListDataset write SetListDataset;
    {$ELSE}
    property ListSource: TDataSource read FListSource write FListSource;
    {$ENDIF}
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWDBMemo32.bmp}
  TIWDBMemo32 = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWDBMemo32), 'TIWDBMemo32.bmp'),
    TIWToolPalette('Intraweb 3.2 DB Controls')]
  {$ENDIF}
  TIWDBMemo32 = class(TIWCustomMemo32, IIWInputControl)
  protected
    FAutoEditable: Boolean;
    FDataField: string;
    FDataSource: TDataSource;
    //
    {$IFDEF VSNET}
    procedure Notification(AComponent: TPlatformComponent; AOperation: TOperation); override;
    {$ELSE}
    procedure Notification(AComponent: TComponent; AOperation: TOperation); override;
    {$ENDIF}
    procedure SetValue(const AValue: string); override;
    procedure InitControl; override;
    {$IFDEF VSNET}
    procedure SetDataset(const Dataset: System.Data.DataTable);
    function GetDataset: System.Data.DataTable;
    function ShouldSerializeDataset: Boolean;
    {$ENDIF}
  public
    destructor Destroy; override;
    function RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag; override;
  published
    property AutoEditable: Boolean read FAutoEditable write FAutoEditable;
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property DataField: string read FDataField write FDataField;
    {$IFDEF VSNET}
    property Dataset: System.Data.DataTable read GetDataset write SetDataset;
    {$ELSE}
    property DataSource: TDataSource read FDataSource write FDataSource;
    {$ENDIF}
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWDBText32.bmp}
  TIWDBText32 = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWDBText32), 'TIWDBText32.bmp'),
    TIWToolPalette('Intraweb 3.2 DB Controls')]
  {$ENDIF}
  TIWDBText32 = class(TIWCustomText32)
  protected
    FDataField: string;
    FDataSource: TDataSource;
    //
    {$IFDEF VSNET}
    procedure Notification(AComponent: TPlatformComponent; AOperation: TOperation); override;
    {$ELSE}
    procedure Notification(AComponent: TComponent; AOperation: TOperation); override;
    {$ENDIF}
    procedure InitControl; override;
    {$IFDEF VSNET}
    procedure SetDataset(const Dataset: System.Data.DataTable);
    function GetDataset: System.Data.DataTable;
    function ShouldSerializeDataset: Boolean;
    {$ENDIF}
  public
    destructor Destroy; override;
    function RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag; override;
  published
    {$IFDEF VSNET}
    [DefaultValue('')]
    {$ENDIF}
    property DataField: string read FDataField write FDataField;
    {$IFDEF VSNET}
    property Dataset: System.Data.DataTable read GetDataset write SetDataset;
    {$ELSE}
    property DataSource: TDataSource read FDataSource write FDataSource;
    {$ENDIF}
    {$IFDEF CLR}
    property WebFont;
    {$ELSE}
    property Font;
    {$ENDIF}
    property RawText;
    property WantReturns;
  end;

implementation

uses
  IWDBCommon,
  SysUtils,
  SWSystem;


{ TIWDBCheckBox32 }

procedure TIWDBCheckBox32.InitControl;
begin
  inherited;
  ValueChecked := 'true';
  ValueUnchecked := 'false';
  FDataField := '';
end;

{$IFDEF VSNET}
procedure TIWDBCheckBox32.Notification(AComponent: TPlatformComponent; AOperation: TOperation);
{$ELSE}
procedure TIWDBCheckBox32.Notification(AComponent: TComponent; AOperation: TOperation);
{$ENDIF}
begin
  inherited Notification(AComponent, AOperation);
  if AOperation = opRemove then begin
    {$IFDEF VSNET}
    if FDatasource.Equals(AComponent) then begin
    {$ELSE}
    if FDatasource = AComponent then begin
    {$ENDIF}
      FDatasource := nil;
    end;
  end;
end;

{$IFDEF VSNET}
procedure TIWDBCheckBox32.SetDataset(const Dataset: System.Data.DataTable);
begin
  FDataSource := GetADONETDataSource(Dataset);
end;

function TIWDBCheckBox32.ShouldSerializeDataset: Boolean;
begin
  result := Assigned(Dataset);
end;

function TIWDBCheckBox32.GetDataset: System.Data.DataTable;
begin
  if FDataSource <> nil then
  begin
    Result := TADONETConnector(FDataSource.DataSet).DataTable;
  end
  else
  begin
    Result := nil;
  end;
end;
{$ENDIF}

destructor TIWDBCheckBox32.Destroy;
begin
  {$IFDEF VSNET}
  ReleaseADONETDataSource(FDataSource);
  {$ENDIF}
  inherited Destroy;
end;

function TIWDBCheckBox32.RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag;
var
  LField: TField;
begin
  if CheckDataSource(FDataSource, DataField, LField) then begin
    FChecked := AnsiSameText(ValueChecked, GetFieldText(LField));
    if AutoEditable then begin
      Editable := InEditMode(FDataSource.Dataset);
    end;
  end else begin
    FChecked := False;
    if AutoEditable then begin
      Editable := False;
    end;
  end;
  Result := inherited RenderHTML(AContext);
end;

procedure TIWDBCheckBox32.SetDataField(const AValue: string);
begin
  FDataField := AValue;
  Invalidate;
end;

procedure TIWDBCheckBox32.SetValue(const AValue: string);
var
  s: string;
  LField: TField;
begin
  inherited SetValue(AValue);
  if CheckDataSource(FDataSource, DataField, LField) then begin
    s := iif(FChecked, ValueChecked, ValueUnChecked);
    if not AnsiSameText(GetFieldText(LField), s) then begin
      FDataSource.Edit;
      LField.Text := s;
    end;
  end;
end;

{ TIWDBComboBox32 }

{$IFDEF VSNET}
procedure TIWDBComboBox32.Notification(AComponent: TPlatformComponent; AOperation: TOperation);
{$ELSE}
procedure TIWDBComboBox32.Notification(AComponent: TComponent; AOperation: TOperation);
{$ENDIF}
begin
  inherited Notification(AComponent, AOperation);
  if AOperation = opRemove then begin
    {$IFDEF VSNET}
    if FDatasource.Equals(AComponent) then begin
    {$ELSE}
    if FDatasource = AComponent then begin
    {$ENDIF}
      FDatasource := nil;
    end;
  end;
end;

{$IFDEF VSNET}
procedure TIWDBComboBox32.SetDataset(const Dataset: System.Data.DataTable);
begin
  FDataSource := GetADONETDataSource(Dataset);
end;

function TIWDBComboBox32.ShouldSerializeDataset: Boolean;
begin
  result := Assigned(Dataset);
end;

function TIWDBComboBox32.GetDataset: System.Data.DataTable;
begin
  if FDataSource <> nil then
  begin
    Result := TADONETConnector(FDataSource.DataSet).DataTable;
  end
  else
  begin
    Result := nil;
  end;
end;
{$ENDIF}

destructor TIWDBComboBox32.Destroy;
begin
  {$IFDEF VSNET}
  ReleaseADONETDataSource(FDataSource);
  {$ENDIF}
  inherited Destroy;
end;

function TIWDBComboBox32.RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag;
var
  LField: TField;
begin
  if CheckDataSource(FDataSource, DataField, LField) then begin
    FItemIndex := Items.IndexOf(GetFieldText(LField));
    if AutoEditable then begin
      Editable := InEditMode(FDataSource.Dataset);
    end;
  end else begin
    FItemIndex := -1;
    if AutoEditable then begin
      Editable := False;
    end;
  end;
  Result := inherited RenderHTML(AContext);
end;

procedure TIWDBComboBox32.InitControl; 
begin
  inherited;
  FDataField := '';
end;

procedure TIWDBComboBox32.SetValue(const AValue: string);
var
  s: string;
  LField: TField;
begin
  inherited SetValue(AValue);
  if CheckDataSource(FDataSource, DataField, LField) then begin
    if FItemIndex > -1 then begin
      with Items do begin
        if ItemsHaveValues then begin
          s := Values[Names[FItemIndex]];
        end
        else begin
          s := Items[FItemIndex];
        end;
      end;
    end else begin
      s := '';
    end;
    if (GetFieldText(LField) <> s) and (s <> '') then begin
      FDataSource.Edit;
      LField.Text := s;
    end;
  end;
end;

{ TIWDBEdit32 }

{$IFDEF VSNET}
procedure TIWDBEdit32.Notification(AComponent: TPlatformComponent; AOperation: TOperation);
{$ELSE}
procedure TIWDBEdit32.Notification(AComponent: TComponent; AOperation: TOperation);
{$ENDIF}
begin
  inherited Notification(AComponent, AOperation);
  if AOperation = opRemove then begin
    {$IFDEF VSNET}
    if FDatasource.Equals(AComponent) then begin
    {$ELSE}
    if FDatasource = AComponent then begin
    {$ENDIF}
      FDatasource := nil;
    end;
  end;
end;

{$IFDEF VSNET}
procedure TIWDBEdit32.SetDataset(const Dataset: System.Data.DataTable);
begin
  FDataSource := GetADONETDataSource(Dataset);
end;

function TIWDBEdit32.ShouldSerializeDataset: Boolean;
begin
  result := Assigned(Dataset);
end;

function TIWDBEdit32.GetDataset: System.Data.DataTable;
begin
  if FDataSource <> nil then
  begin
    Result := TADONETConnector(FDataSource.DataSet).DataTable;
  end
  else
  begin
    Result := nil;
  end;
end;
{$ENDIF}

procedure TIWDBEdit32.Paint;
begin
  Text := DataField;
  inherited Paint;
end;

destructor TIWDBEdit32.Destroy;
begin
  {$IFDEF VSNET}
  ReleaseADONETDataSource(FDataSource);
  {$ENDIF}
  inherited Destroy;
end;

function TIWDBEdit32.RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag;
var
  LField: TField;
begin
  if CheckDataSource(FDataSource, DataField, LField) then begin
    if AutoEditable then begin
      Editable := InEditMode(FDataSource.Dataset);
    end;
    if Editable then begin
      if LField.DataType in [ftDate, ftTime, ftDateTime] then begin
        Text := LField.DisplayText;
      end else begin
        Text := GetFieldText(LField);
      end;
    end else begin
      Text := LField.DisplayText;
    end;

    if (LField.DataType = ftString) then begin
    //TODO: Add this to base class if 3.2 supports length
//      MaxLength := LField.Size;
    end;
  end else begin
    Text := '';
    if AutoEditable then begin
      Editable := False;
    end;
  end;
  Result := inherited RenderHTML(AContext);
end;

procedure TIWDBEdit32.InitControl; 
begin
  inherited;
  FDataField := '';
end;

procedure TIWDBEdit32.SetValue(const AValue: string);
var
  LField: TField;
begin
  inherited SetValue(AValue);
  if CheckDataSource(FDataSource, DataField, LField) then begin
    if (GetFieldText(LField) <> Text) then begin
      FDatasource.Edit;
      LField.Text := Text;
    end;
  end;
end;

{ TIWDBLabel32 }

{$IFDEF VSNET}
procedure TIWDBLabel32.Notification(AComponent: TPlatformComponent; AOperation: TOperation);
{$ELSE}
procedure TIWDBLabel32.Notification(AComponent: TComponent; AOperation: TOperation);
{$ENDIF}
begin
  inherited Notification(AComponent, AOperation);
  if AOperation = opRemove then begin
    {$IFDEF VSNET}
    if FDatasource.Equals(AComponent) then begin
    {$ELSE}
    if FDatasource = AComponent then begin
    {$ENDIF}
      FDatasource := nil;
    end;
  end;
end;

{$IFDEF VSNET}
procedure TIWDBLabel32.SetDataset(const Dataset: System.Data.DataTable);
begin
  FDataSource := GetADONETDataSource(Dataset);
end;

function TIWDBLabel32.ShouldSerializeDataset: Boolean;
begin
  result := Assigned(Dataset);
end;

function TIWDBLabel32.GetDataset: System.Data.DataTable;
begin
  if FDataSource <> nil then
  begin
    Result := TADONETConnector(FDataSource.DataSet).DataTable;
  end
  else
  begin
    Result := nil;
  end;
end;
{$ENDIF}

procedure TIWDBLabel32.InitControl; 
begin
  inherited;
  FDataField := '';
end;

procedure TIWDBLabel32.Paint;
begin
  if Length(DataField) = 0 then begin
    Caption := Name;
  end else begin
    Caption := DataField;
  end;
  inherited Paint;
end;

destructor TIWDBLabel32.Destroy;
begin
  {$IFDEF VSNET}
  ReleaseADONETDataSource(FDataSource);
  {$ENDIF}
  inherited Destroy;
end;

function TIWDBLabel32.RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag;
var
  LField: TField;
begin
  if CheckDataSource(FDataSource, DataField, LField) then begin
    // Still need this check for TDateTimeField with .DisplayText?
    if LField is TDateTimeField then begin
      Caption := FormatDateTime(TDateTimeField(LField).DisplayFormat, LField.AsDateTime);
    end else begin
      Caption := LField.DisplayText;
    end;
  end else begin
    Caption := '';
  end;
  Result := inherited RenderHTML(AContext);
end;

{ TIWDBListbox32 }

{$IFDEF VSNET}
procedure TIWDBListbox32.Notification(AComponent: TPlatformComponent; AOperation: TOperation);
{$ELSE}
procedure TIWDBListbox32.Notification(AComponent: TComponent; AOperation: TOperation);
{$ENDIF}
begin
  inherited Notification(AComponent, AOperation);
  if AOperation = opRemove then begin
    {$IFDEF VSNET}
    if FDatasource.Equals(AComponent) then begin
    {$ELSE}
    if FDatasource = AComponent then begin
    {$ENDIF}
      FDatasource := nil;
    end;
  end;
end;

{$IFDEF VSNET}
procedure TIWDBListbox32.SetDataset(const Dataset: System.Data.DataTable);
begin
  FDataSource := GetADONETDataSource(Dataset);
end;

function TIWDBListbox32.ShouldSerializeDataset: Boolean;
begin
  result := Assigned(Dataset);
end;

function TIWDBListbox32.GetDataset: System.Data.DataTable;
begin
  if FDataSource <> nil then
  begin
    Result := TADONETConnector(FDataSource.DataSet).DataTable;
  end
  else
  begin
    Result := nil;
  end;
end;
{$ENDIF}

destructor TIWDBListbox32.Destroy;
begin
  {$IFDEF VSNET}
  ReleaseADONETDataSource(FDataSource);
  {$ENDIF}
  inherited Destroy;
end;

function TIWDBListbox32.RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag;
var
  LField: TField;
begin
  if CheckDataSource(FDataSource, DataField, LField) then begin
    FItemIndex := Items.IndexOf(GetFieldText(LField));
    if AutoEditable then begin
      Editable := InEditMode(FDataSource.Dataset);
    end;
  end else begin
    FItemIndex := -1;
    if AutoEditable then begin
      Editable := False;
    end;
  end;
  Result := inherited RenderHTML(AContext);
end;

procedure TIWDBListbox32.InitControl; 
begin
  inherited;
  FDataField := '';
end;

procedure TIWDBListbox32.SetValue(const AValue: string);
var
  s: string;
  LField: TField;
begin
  inherited SetValue(AValue);
  if CheckDataSource(FDataSource, DataField, LField) then begin
    if FItemIndex > -1 then begin
      with Items do begin
        if ItemsHaveValues then begin
          s := Values[Names[FItemIndex]];
        end
        else begin
          s := Items[FItemIndex];
        end;
      end;
    end else begin
      s := '';
    end;
    if (GetFieldText(LField) <> s) then begin
      FDataSource.Edit;
      LField.Text := s;
    end;
  end;
end;

{ TIWDBLookupComboBox32 }

procedure TIWDBLookupComboBox32.InitControl;
begin
  inherited;
  FKeyItems := TStringList.Create;
  FItemIndex := -1;
  FDataField := '';
  FListField := '';
  FKeyField := '';
end;

destructor TIWDBLookupComboBox32.Destroy;
begin
  {$IFDEF VSNET}
  ReleaseADONETDataSource(FDataSource);
  ReleaseADONETDataSource(FListSource);
  {$ENDIF}
  FreeAndNil(FKeyItems);
  inherited;
end;

{$IFDEF VSNET}
procedure TIWDBLookupComboBox32.Notification(AComponent: TPlatformComponent; AOperation: TOperation);
{$ELSE}
procedure TIWDBLookupComboBox32.Notification(AComponent: TComponent; AOperation: TOperation);
{$ENDIF}
begin
  inherited Notification(AComponent, AOperation);
  if AOperation = opRemove then begin
    {$IFDEF VSNET}
    if FDatasource.Equals(AComponent) then begin
    {$ELSE}
    if FDatasource = AComponent then begin
    {$ENDIF}
      FDatasource := nil;
    end;
    {$IFDEF VSNET}
    if FListsource.Equals(AComponent) then begin
    {$ELSE}
    if FListsource = AComponent then begin
    {$ENDIF}
      FListSource := nil;
    end;
  end;
end;

{$IFDEF VSNET}
procedure TIWDBLookupComboBox32.SetDataset(const Dataset: System.Data.DataTable);
begin
  FDataSource := GetADONETDataSource(Dataset);
end;

function TIWDBLookupComboBox32.ShouldSerializeDataset: Boolean;
begin
  result := Assigned(Dataset);
end;

function TIWDBLookupComboBox32.GetDataset: System.Data.DataTable;
begin
  if FDataSource <> nil then
  begin
    Result := TADONETConnector(FDataSource.DataSet).DataTable;
  end
  else
  begin
    Result := nil;
  end;
end;

procedure TIWDBLookupComboBox32.SetListDataset(const Dataset: System.Data.DataTable);
begin
  FListSource := GetADONETDataSource(Dataset);
end;

function TIWDBLookupComboBox32.ShouldSerializeListDataset: Boolean;
begin
  result := Assigned(ListDataset);
end;

function TIWDBLookupComboBox32.GetListDataset: System.Data.DataTable;
begin
  if FListSource <> nil then
  begin
    Result := TADONETConnector(FListSource.DataSet).DataTable;
  end
  else
  begin
    Result := nil;
  end;
end;
{$ENDIF}

function TIWDBLookupComboBox32.RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag;
var
  LField: TField;
  LKeyField: TField;
begin
  Items.Clear;
  FKeyItems.Clear;
  if CheckDataSource(FListSource, ListField, LField)
   and CheckDataSource(FListSource, KeyField, LKeyField) then begin
    FListSource.DataSet.First;
    while not FListSource.Dataset.EOF do begin
      Items.Add(GetFieldText(LField));
      FKeyItems.Add(GetFieldText(LKeyField));
      FListSource.DataSet.Next;
    end;
  end;
  if CheckDataSource(FDataSource, DataField, LField) then begin
    if LField.IsNull then begin
      FItemIndex := -1;
    end else begin
      FItemIndex := FKeyItems.IndexOf(GetFieldText(LField));
    end;
    if AutoEditable then begin
      Editable := InEditMode(FDataSource.Dataset);
    end;
  end else begin
    //FItemIndex := -1;
    if AutoEditable then begin
      Editable := False;
    end;
  end;
  Result := inherited RenderHTML(AContext);
end;

procedure TIWDBLookupComboBox32.SetValue(const AValue: string);
var
  s: string;
  LField: TField;
begin
  inherited SetValue(AValue);
  if CheckDataSource(FDataSource, DataField, LField) then begin
    if ItemIndex = -1 then begin
      s := #0;
    end else begin
      s := FKeyItems[ItemIndex];
    end;
    if ((LField.IsNull) and (S <> #0)) or (GetFieldText(LField) <> s) then begin
      FDataSource.Edit;
      if s = #0 then begin
        LField.Clear;
      end else begin
        LField.Text := s;
      end;
    end;
  end;
end;

{ TIWDBLookupListBox32 }

procedure TIWDBLookupListBox32.InitControl;
begin
  inherited;
  FKeyItems := TStringList.Create;
  FDataField := '';
  FKeyField := '';
  FListField := '';
end;

destructor TIWDBLookupListBox32.Destroy;
begin
  {$IFDEF VSNET}
  ReleaseADONETDataSource(FDataSource);
  ReleaseADONETDataSource(FListSource);
  {$ENDIF}
  FreeAndNil(FKeyItems);
  inherited Destroy;
end;

{$IFDEF VSNET}
procedure TIWDBLookupListBox32.Notification(AComponent: TPlatformComponent; AOperation: TOperation);
{$ELSE}
procedure TIWDBLookupListBox32.Notification(AComponent: TComponent; AOperation: TOperation);
{$ENDIF}
begin
  inherited Notification(AComponent, AOperation);
  if AOperation = opRemove then begin
    {$IFDEF VSNET}
    if FDatasource.Equals(AComponent) then begin
    {$ELSE}
    if FDatasource = AComponent then begin
    {$ENDIF}
      FDatasource := nil;
    end;
    {$IFDEF VSNET}
    if FListSource.Equals(AComponent) then begin
    {$ELSE}
    if FListSource = AComponent then begin
    {$ENDIF}
      FListSource := nil;
    end;
  end;
end;

{$IFDEF VSNET}
procedure TIWDBLookupListBox32.SetDataset(const Dataset: System.Data.DataTable);
begin
  FDataSource := GetADONETDataSource(Dataset);
end;

function TIWDBLookupListBox32.ShouldSerializeDataset: Boolean;
begin
  result := Assigned(Dataset);
end;

function TIWDBLookupListBox32.GetDataset: System.Data.DataTable;
begin
  if FDataSource <> nil then
  begin
    Result := TADONETConnector(FDataSource.DataSet).DataTable;
  end
  else
  begin
    Result := nil;
  end;
end;

procedure TIWDBLookupListBox32.SetListDataset(const Dataset: System.Data.DataTable);
begin
  FListSource := GetADONETDataSource(Dataset);
end;

function TIWDBLookupListBox32.ShouldSerializeListDataset: Boolean;
begin
  result := Assigned(ListDataset);
end;

function TIWDBLookupListBox32.GetListDataset: System.Data.DataTable;
begin
  if FListSource <> nil then
  begin
    Result := TADONETConnector(FListSource.DataSet).DataTable;
  end
  else
  begin
    Result := nil;
  end;
end;
{$ENDIF}

function TIWDBLookupListBox32.RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag;
var
  LField: TField;
  LKeyField: TField;
begin
  Items.Clear;
  FKeyItems.Clear;
  if CheckDataSource(FListSource, ListField, LField)
   and CheckDataSource(FListSource, KeyField, LKeyField) then begin
    FListSource.DataSet.First;
    while not FListSource.Dataset.EOF do begin
      Items.Add(GetFieldText(LField));
      FKeyItems.Add(GetFieldText(LKeyField));
      FListSource.DataSet.Next;
    end;
  end;
  if CheckDataSource(FDataSource, DataField, LField) then begin
    if LField.IsNull then begin
      FItemIndex := -1;
    end else begin
      FItemIndex := FKeyItems.IndexOf(GetFieldText(LField));
    end;
    if AutoEditable then begin
      Editable := InEditMode(FDataSource.Dataset);
    end;
  end else begin
    //FItemIndex := -1;
    if AutoEditable then begin
      Editable := False;
    end;
  end;
  Result := inherited RenderHTML(AContext);
end;

procedure TIWDBLookupListBox32.SetValue(const AValue: string);
var
  s: string;
  LField: TField;
begin
  inherited SetValue(AValue);
  if CheckDataSource(FDataSource, DataField, LField) then begin
    if FItemIndex = -1 then begin
      s := #0;
    end else begin
      s := FKeyItems[FItemIndex];
    end;
    if ((LField.IsNull) and (S <> #0)) or (GetFieldText(LField) <> s) then begin
      FDataSource.Edit;
      if s = #0 then begin
        LField.Clear;
      end else begin
        LField.Text := s;
      end;
    end;
  end;
end;

{ TIWDBMemo }

{$IFDEF VSNET}
procedure TIWDBMemo32.Notification(AComponent: TPlatformComponent; AOperation: TOperation);
{$ELSE}
procedure TIWDBMemo32.Notification(AComponent: TComponent; AOperation: TOperation);
{$ENDIF}
begin
  inherited Notification(AComponent, AOperation);
  if AOperation = opRemove then begin
    {$IFDEF VSNET}
    if FDatasource.Equals(AComponent) then begin
    {$ELSE}
    if FDatasource = AComponent then begin
    {$ENDIF}
      FDatasource := nil;
    end;
  end;
end;

{$IFDEF VSNET}
procedure TIWDBMemo32.SetDataset(const Dataset: System.Data.DataTable);
begin
  FDataSource := GetADONETDataSource(Dataset);
end;

function TIWDBMemo32.ShouldSerializeDataset: Boolean;
begin
  result := Assigned(Dataset);
end;

function TIWDBMemo32.GetDataset: System.Data.DataTable;
begin
  if FDataSource <> nil then
  begin
    Result := TADONETConnector(FDataSource.DataSet).DataTable;
  end
  else
  begin
    Result := nil;
  end;
end;
{$ENDIF}

destructor TIWDBMemo32.Destroy;
begin
  {$IFDEF VSNET}
  ReleaseADONETDataSource(FDataSource);
  {$ENDIF}
  inherited Destroy;
end;

function TIWDBMemo32.RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag;
var
  LField: TField;
begin
  if CheckDataSource(FDataSource, DataField, LField) then begin
    FLines.Text := GetFieldText(LField);
    FEndsWithCRLF := FLines.Text = GetFieldText(LField);
    if AutoEditable then begin
      Editable := InEditMode(FDataSource.Dataset);
    end;
  end else begin
    FLines.Clear;
    if AutoEditable then begin
      Editable := False;
    end;
  end;
  Result := inherited RenderHTML(AContext);
end;

procedure TIWDBMemo32.InitControl; 
begin
  inherited;
  FDataField := '';
end;

procedure TIWDBMemo32.SetValue(const AValue: string);
var
  LField: TField;
begin
  inherited SetValue(AValue);
  if CheckDataSource(FDataSource, DataField, LField) then begin
    // After SetValue Text holds the real value
    // When AValue does not end with CR-LF FLisnes automatically adds CRLF
    if (GetFieldText(LField) <> Text) then begin
      FDatasource.Edit;
      LField.AsString := Text;
    end;
  end;
end;

{ TIWDBText32 }

{$IFDEF VSNET}
procedure TIWDBText32.Notification(AComponent: TPlatformComponent; AOperation: TOperation);
{$ELSE}
procedure TIWDBText32.Notification(AComponent: TComponent; AOperation: TOperation);
{$ENDIF}
begin
  inherited Notification(AComponent, AOperation);
  if AOperation = opRemove then begin
    {$IFDEF VSNET}
    if FDatasource.Equals(AComponent) then begin
    {$ELSE}
    if FDatasource = AComponent then begin
    {$ENDIF}
      FDatasource := nil;
    end;
  end;
end;

procedure TIWDBText32.InitControl; 
begin
  inherited;
  FDataField := '';
end;

{$IFDEF VSNET}
procedure TIWDBText32.SetDataset(const Dataset: System.Data.DataTable);
begin
  FDataSource := GetADONETDataSource(Dataset);
end;

function TIWDBText32.ShouldSerializeDataset: Boolean;
begin
  result := Assigned(Dataset);
end;

function TIWDBText32.GetDataset: System.Data.DataTable;
begin
  if FDataSource <> nil then
  begin
    Result := TADONETConnector(FDataSource.DataSet).DataTable;
  end
  else
  begin
    Result := nil;
  end;
end;
{$ENDIF}
destructor TIWDBText32.Destroy;
begin
  {$IFDEF VSNET}
  ReleaseADONETDataSource(FDataSource);
  {$ENDIF}
  inherited Destroy;
end;

function TIWDBText32.RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag;
var
  LField: TField;
begin
  if CheckDataSource(FDataSource, DataField, LField) then begin
    if LField.DataType in [ftDate, ftTime, ftDateTime] then begin
      FLines.Text := LField.DisplayText;
    end else begin
      FLines.Text := GetFieldText(LField);
    end;
  end else begin
    FLines.Clear;
  end;
  Result := inherited RenderHTML(AContext);
end;

end.
